%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This work by EPFL STI IBI LBNI is licensed under 
% a Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
% Based on a work at http://lbni.epfl.ch/.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function [ improv_param, gaussian_fit_std, gaussian_fit_ampl ] = check_improvement( im , previous_gaussian_std, previous_gaussian_ampl, min_spacing_stdev, max_spacing_stdev, amplitude_fract, min_peak_distance, min_peak_height, peak_threshold, ~, ~, ~, ~, histogram_bins, smoothing_level, ~, ~, ref_peak_pos, peaks_fit,j,S,index)
%CHECK_IMPROVEMENT: This function checks if the image improved or not by
%comparing the area and standard deviations of each peak
%       Input parameters: 
%           - im : image
%           - previous_gaussian_std: stds of each peak before the current step
%           - previous_gaussian_ampl: amplitudes of each peak before the current step
%           - min_spacing_stdev, max_spacing_stdev: defined at the beginning of
%           Nano6_Flatten_surf_poly
%           - amplitude_fract, min_peak_distance, min_peak_height, peak_threshold:
%           parameters to correctly find the peaks in the histogram
%           - position_est, peak_height_est, peak_index_est: parameters of
%           the estimated peaks in order to identify the peaks correctly
%           - peak_pos_tolerance: to identify correctly the corresponding peaks
%       Output parameters:
%           - improv_param: positive in case of improvement, else negative
%           - gaussian_fit_std, gaussian_fit_ampl: new standard deviations and
%           amplitudes for each peak after the current step

                                             
        image_inside_range                          = im;

        [h_lim x_lim]                               = ecdf(reshape(im,size(im,1)*size(im,2),1));
        min_hist                                    = floor(x_lim(find(h_lim >= 0.02,1)));
        max_hist                                    =  ceil(x_lim(find(h_lim >= 0.98,1)));
        
        image_inside_range((im(:,:) < min_hist))    = NaN;                                                                                                              
        image_inside_range((im(:,:) > max_hist))    = NaN; 

        [gaussian_fit, gaussian_gof, n_peaks]       = fit_multi_gauss(image_inside_range,index,j,S,min_spacing_stdev,max_spacing_stdev,amplitude_fract,smoothing_level);

            
 
%         figure('Name','Improvement Check Plot')
%         plot(position',height);
%         hold on;
%         plot(gaussian_fit);
%         axis square;
%         axis tight;
%         %text(min(position),max(height),gaussian_fit);
%         disp(gaussian_fit)
        % Combines all the amplitudes, the positions and the standard
        % deviations into one vector
    gaussian_fit_ampl = [];
    gaussian_fit_std = [];
    for i = 1:n_peaks
       eval(['gaussian_fit_ampl(', num2str(i), ')= gaussian_fit.a', num2str(i), ';']);
       eval(['gaussian_fit_pos(', num2str(i), ')= gaussian_fit.b', num2str(i), ';']);
       eval(['gaussian_fit_std(', num2str(i), ')= gaussian_fit.c', num2str(i), ';']);
    end
    weighted_average = 0;
    previous_weighted_average = 0;
    
    previous_peak_area                          = zeros(1,min([3 length(gaussian_fit_std), length(previous_gaussian_std)]));
    peak_area                                   = zeros(1,min([3 length(gaussian_fit_std), length(previous_gaussian_std)]));
    for i                                       = 1:min([3 length(gaussian_fit_std), length(previous_gaussian_std)])
        previous_peak_area(i)                   = previous_gaussian_std(i) * previous_gaussian_ampl(i);
        peak_area(i)                            = gaussian_fit_ampl(i)*gaussian_fit_std(i);                  % Area under the gaussian curve = amplitude * std * sqrt(pi)
        weighted_average                        = weighted_average + peak_area(i)*gaussian_fit_std(i);
        previous_weighted_average               = previous_weighted_average + previous_peak_area(i)*previous_gaussian_std(i);
        % disp(['Peak number ', num2str(i), ': Previous peak area = ', num2str(previous_peak_area(i)), ': Peak area = ', num2str(peak_area(i)), '; Previous std = ', num2str(previous_gaussian_std(i)), '; Current std =' ,  num2str(gaussian_fit_std(i))])
    end

    weighted_average = weighted_average / sum(peak_area);
    previous_weighted_average = previous_weighted_average / sum(previous_peak_area);

    % disp(['Weighted_average = ', num2str(weighted_average), '; Previous_weighted_average = ', num2str(previous_weighted_average)]);

    if weighted_average <= previous_weighted_average && gaussian_gof.adjrsquare > 0.45
          improv_param = 1; % improvement
    else                                                               
          improv_param = -1; % degradation
    end
end

